<?php // Versión 6.1

  class Plantilla {

    private $menu;
    private $submenu;
    private $friendly;
    private $webtitle;
    private $item;
    private $subitem;
    private $dircontents;

    public function __construct() {
      $this->menu = array('start' => "Inicio");
      $this->submenu = array();
      $this->friendly = true;
      $this->webtitle = "*** Ecuador ***";
      $this->item = $this->getParameter('item', 'start');
      $this->subitem = $this->getParameter('subitem');
      $this->dircontents = "/futbol_new/";
    }

    private function getParameter($name, $default='') {
      if (isset($_GET[$name])) {
        $value = $_GET[$name];
        $value = strip_tags($value);    // Elimina les etiquetes <>
        $value = substr($value, 0, 20); // Limitar la longitud a la clau més llarga
      }
      else {
        $value = $default;
      }
      /*echo '<script language="JavaScript"> 
					alert("El Item '.$value.'"); 
                  </script>';*/
      return $value;
    }

    public function setMenu ($menu, $submenu) {
      $this->menu = $menu;
      $this->submenu = $submenu;
    }

    public function setFriendly($friendly) {
      $this->friendly = $friendly;
    }

    public function setWebTitle($webtitle) {
      $this->webtitle = $webtitle;
    }

    public function setDirContents($dircontents) {
      $this->dircontents = $dircontents;
    }

    public function getPageTitle()
    {
      $menu     = $this->menu;
      $submenu  = $this->submenu;
      $item     = $this->item;
      $subitem  = $this->subitem;
      $webtitle = $this->webtitle;

      $title = '';
      if (isset($submenu[$item][$subitem])) {
        $title .= $submenu[$item][$subitem] . ' - ';
      }
      if (isset($menu[$item])) {
        $title .= $menu[$item] . ' - ';
      }
      return "$title $webtitle";
    }

    public function getClassBody() {
      $item     = $this->item;
      $subitem  = $this->subitem;
      $classe = "$item $subitem";
      return $classe;
    }

     public function getMenu($niv=NULL)
    {
      //echo "Parametro nivel = " . $niv;
      $menu     = $this->menu;
      $submenu  = $this->submenu;
      $item     = $this->item;
      $subitem  = $this->subitem;
      $list = '';
      foreach($menu as $key=>$value) {
      	//echo "<br>key = " . $key;
      	
      	
      	// *** if(($key=='salir') || ($key=='consulta')|| ($key=='diario') || ($niv == 3) || ($niv==2 && $key != 'admin')){
	        if (isset($submenu[$key])) {
	          $sublist = '';
	          foreach ($submenu[$key] as $subkey=>$subvalue) {
	            if($niv == 1 && ($subkey=='torneo' || $subkey=='jugador_eq')){
	            }else{
	                $subclass = ($subkey == $subitem)? ' class="subcurrent"' : '';
	                //echo "<br>nivel: " . $niv . " item: " . $subkey;
	                $href = $this->getHRef($key, $subkey);
	                $sublist .= "\t\t<li id=\"$subkey\"$subclass><a href=\"paginas/$href\">$subvalue</a></li>\n";
	            }
	          }
	          $sublist = "\n\t\t<ul>\n$sublist\t\t</ul>\n\t";
	        }else {
	          $sublist = '';
	        }
	    // *** }else {
          // *** $sublist = '';
        // *** }
        
        
        $class = ($key == $item)? ' class="current"' : '';
        $href = $this->getHRef($key);
        $list .= "\t<li id=\"$key\"$class>".
          "<a href=\"paginas/$href\">$value</a>$sublist</li>\n";
          //"<a href=\"$href\">$value</a>$sublist</li>\n";
      }
      return "\n\t<ul>\n$list\t</ul>\n";
    }

    public function writePageContent($dir=null, $warnings=true) {
      $item     = $this->item;
      $subitem  = $this->subitem;
      $dircontents = $dir===null? $this->dircontents: $dir;

      if (empty($subitem)) $file = $dircontents.$item.".php";
      else $file = $dircontents.$item."_".$subitem.".php";

      if (file_exists($file)) include $file;
      else if ($warnings) echo '<p class="error">Missing file: <code>'.$file.'</code></p>';
    }

    public function getBreadcrumbs($separator=' &gt; ')
    {
      $menu     = $this->menu;
      $submenu  = $this->submenu;
      $item     = $this->item;
      $subitem  = $this->subitem;
      $list = array();

      if ($subitem != '') {
        $list[] = $this->getTitle($item, $subitem);
      }
      if ($item != 'start') {
        if (count($list) == 0) $list[] = $this->getTitle($item);
        else $list[] = $this->getTagA($item);
      }
      if (count($list) == 0) $list[] = $this->getTitle('start');
      else $list[] = $this->getTagA('start');

      return implode($separator, array_reverse($list));
    }

    private function getTagA($item, $subitem='') {
      $href = $this->getHRef($item, $subitem);
      $title = $this->getTitle($item, $subitem);
      return "<a href=\"paginas/$href\">$title</a>";
      //return "<a href=\"$href\">$title</a>";
    }
    private function getHRef($item, $subitem='') {
      if ($this->friendly) {
        //if ($subitem == '') return "$item.html";
        if ($subitem == '') return "$item.php";
        //else return $item."_".$subitem.".html";
        // cambio hecho por mi *********** else return $item."_".$subitem.".php";
        else return $subitem.".php";
      }
      else {
        if ($subitem == '') return "?item=$item";
        else return "?item=$item&subitem=$subitem";
      }
    }
    private function getTitle($item, $subitem='') {
      if ($subitem == '') {
        if (isset($this->menu[$item])) return $this->menu[$item];
        else return $item;
      }
      else {
        if (isset($this->submenu[$item][$subitem])) return $this->submenu[$item][$subitem];
        else return $subitem;
      }
    }
} 
?>
